<?php ob_start();
defined('BASEPATH') OR exit('No direct script access allowed');

class Bills extends Admin_controller
{

    function __construct()
    {
        parent::__construct();
        $this->load->model('bills_model');
        $this->load->model('settings_model');
    }

    /* Get all bill in case user go on index page */
    public function index($id = false, $clientid = false)
    {
      
         $has_permission = has_permission('manageBills');

         if(!$has_permission && !$this->input->is_ajax_request()){
            access_denied('manageBills');
         }

         $_status = '';

         if($this->input->get('status')){
            $_status = $this->input->get('status');
         }

        if ($this->input->is_ajax_request()) {
            // From client profile
            if(is_numeric($clientid)){
                if(!$has_permission){
                    echo json_encode(json_decode('{"draw":1,"iTotalRecords":"0","iTotalDisplayRecords":"0","aaData":[]}'));
                    die;
                }
            }

            $aColumns = array(
                'bill_date',
                'bill_number',
                'refrence',
                'supplierid',
                'total',
                'due_date',
                'billid',                
                'status',
             
            );

            $join = array(
                'LEFT JOIN tblsuppliers ON tblsuppliers.userid = tblbills.supplierid',
                'LEFT JOIN tblcurrencies ON tblcurrencies.id = tblbills.currency'
            );

            $where = array();



            if ($this->input->post('status')) {
                array_push($where, 'AND status=' . $this->input->post('status'));
            }

            if($this->input->post('custom_view')){
                $custom_view = $this->input->post('custom_view');
                if($custom_view == 'not_sent'){
                     array_push($where,'AND sent=0');
                 }
            }
 
            $sIndexColumn = "billid";
            $sTable       = 'tblbills';
            $result       = data_tables_init($aColumns, $sIndexColumn, $sTable, $join, $where, array('billid','supplier','symbol'));
            $output       = $result['output'];
            $rResult      = $result['rResult'];

            foreach ($rResult as $aRow) {
                $row = array();

                for ($i = 0; $i < count($aColumns); $i++) {
                    $_data  = $aRow[$aColumns[$i]];
                    if ($aColumns[$i] == 'bill_number') {
                       $_data = '<a href="#" onclick="init_bill('.$aRow['billid'].'); return false;">' . $_data . '</a><br />';
                    } else if ($aColumns[$i] == 'status') {
                     $_data = format_bills_status($aRow['status']);
                     }
                     else if ($aColumns[$i] == 'bill_date') {
                         $_data  = _d($_data);
                     }
                     else if ($aColumns[$i] == 'supplierid') {
                         $_data  =  '<a href="' . admin_url('suppliers/supplier/' . $aRow['supplierid']) . '">' . $aRow['supplier'] . '</a>';
                     }
                     else if ($aColumns[$i] == 'total') {
                         $_data  =  format_money($_data, $aRow['symbol']);
                     }else if ($aColumns[$i] == 'due_date') {
                         $_data  = _d($_data);
                     }
                     else if ($aColumns[$i] == 'due_date') {
                         $_data  = _d($_data);
                     }
                     else if ($aColumns[$i] == 'billid') {
                         $_data  = '$0.00';
                     }
                    $row[] = $_data;
                }
                
                
//                 $options = "<a href='".admin_url('payments/newpayment/'. $aRow['billid'])."'><i class='fa fa-money'  aria-hidden='true'></i></a>";    
//                $options = icon_btn('#', 'eye','',array('data-toggle' => 'tooltip', 'title' =>'View Invoice', 'onclick'=>'init_invoice('.$aRow['id'].'); return false;'));
                $options = icon_btn('admin/bills/bill/' . $aRow['billid'], 'pencil-square-o','',array('data-toggle' => 'tooltip', 'title' =>'Edit Bill'));
                $options .= icon_btn('admin/bills/delete/' . $aRow['billid'], 'remove', '', array('data-toggle' => 'tooltip','onClick' => 'return deleteconf();','title' => 'Delete Bill'));
                 $row[] =$options;
                $output['aaData'][] = $row;
            }

            echo json_encode($output);
            die();
        }

        $data['estimateid'] = '';
        if (is_numeric($id)) {
            $data['estimateid'] = $id;
        }


        $data['status'] = $_status;
        $data['bodyclass'] = 'small-table';
        $data['title']     = _l('bill');
        $this->load->view('admin/bills/manage', $data);
    }

    public function get_bill_data_ajax($id)
    {
        if(!has_permission('manageGrn')){
            access_denied('manageGrn');
        }

        if (!$id) {
            die('No order found');
        }

        $bill = $this->bills_model->get_bill($id);
        
        // $data['bill_po'] = $this->bills_model->getbill_po($id);
        // $data['bill_grn'] = $this->bills_model->getbill_grn();

        // $data['bill_items'] = $this->bills_model->getbill_items($id);
        $data['bill_items'] = $this->bills_model->getsupplierbill_items($id);
        // print_r($data['bill_items']);
        // die;
        $data['bill']  = $bill;
        $this->load->view('admin/bills/bills_preview_template', $data);
    }

    public function getbills($id = false, $clientid = false){
        
         $has_permission = has_permission('manageBills');

         if(!$has_permission && !$this->input->is_ajax_request()){
            access_denied('manageBills');
         }

         $_status = '';

         if($this->input->get('status')){
            $_status = $this->input->get('status');
         }

        if ($this->input->is_ajax_request()) {
            // From client profile
            if(is_numeric($clientid)){
                if(!$has_permission){
                    echo json_encode(json_decode('{"draw":1,"iTotalRecords":"0","iTotalDisplayRecords":"0","aaData":[]}'));
                    die;
                }
            }

            $aColumns = array(
                'bill_number',
                'bill_date',                
                'refrence',
                'total',
                'due_date',
                'currency',          
                'status',
             
            );

            $join = array(
                'LEFT JOIN tblsuppliers ON tblsuppliers.userid = tblbills.supplierid',
                'LEFT JOIN tblcurrencies ON tblcurrencies.id = tblbills.currency'
            );

            $where = array();



            if ($this->input->post('status')) {
                array_push($where, 'AND status=' . $this->input->post('status'));
            }

            if($this->input->post('custom_view')){
                $custom_view = $this->input->post('custom_view');
                if($custom_view == 'not_sent'){
                     array_push($where,'AND sent=0');
                 }
            }
             array_push($where,'AND supplierid='.$id);
 
            $sIndexColumn = "billid";
            $sTable       = 'tblbills';
            $result       = data_tables_init($aColumns, $sIndexColumn, $sTable, $join, $where, array('billid','supplier','symbol','tblcurrencies.name'));
            $output       = $result['output'];
            $rResult      = $result['rResult'];

            foreach ($rResult as $aRow) {
                $row = array();

                for ($i = 0; $i < count($aColumns); $i++) {
                    $_data  = $aRow[$aColumns[$i]];
                     if ($aColumns[$i] == 'status') {
                     $_data = format_bills_status($aRow['status']);
                     }
                     else if ($aColumns[$i] == 'bill_date') {
                         $_data  = _d($_data);
                     }
                     else if ($aColumns[$i] == 'total') {
                         $_data  =  format_money($_data, $aRow['symbol']);
                     }else if ($aColumns[$i] == 'due_date') {
                         $_data  = _d($_data);
                     }
                     else if ($aColumns[$i] == 'currency') {
                         $_data  = $aRow['name'];
                     }
                    $row[] = $_data;
                }
                
                
                 $options = "<a href='".admin_url('make_payment/'. $aRow['billid'])."'><i class='fa fa-money'  aria-hidden='true'></i></a>";    
//                $options = icon_btn('#', 'eye','',array('data-toggle' => 'tooltip', 'title' =>'View Invoice', 'onclick'=>'init_invoice('.$aRow['id'].'); return false;'));
                $options .= icon_btn('admin/bills/bill/' . $aRow['billid'], 'pencil-square-o','',array('data-toggle' => 'tooltip', 'title' =>'Edit Bill'));
                $options .= icon_btn('#', 'remove', 'deletebill', array('data-toggle' => 'tooltip', 'title' => 'Delete Bill','data-id'=>$aRow['billid']));
                 $row[] =$options;
                $output['aaData'][] = $row;
            }

            echo json_encode($output);
            die();
        }

       
    }

    /* List all bill datatables */
    public function list_bill($id = false, $clientid = false)
    {
        
          $has_permission = has_permission('manageBills');

         if(!$has_permission && !$this->input->is_ajax_request()){
            access_denied('manageBills');
         }

         $_status = '';

         if($this->input->get('status')){
            $_status = $this->input->get('status');
         }

        if ($this->input->is_ajax_request()) {
            // From client profile
            if(is_numeric($clientid)){
                if(!$has_permission){
                    echo json_encode(json_decode('{"draw":1,"iTotalRecords":"0","iTotalDisplayRecords":"0","aaData":[]}'));
                    die;
                }
            }

            $aColumns = array(
                'bill_date',
                'bill_number',
                'refrence',
                'supplierid',
                'total',
                'due_date',
                'billid',                
                'status',
             
            );

            $join = array(
                'LEFT JOIN tblsuppliers ON tblsuppliers.userid = tblbills.supplierid',
                'LEFT JOIN tblcurrencies ON tblcurrencies.id = tblbills.currency'
            );

            $where = array();



            if ($this->input->post('status')) {
                array_push($where, 'AND status=' . $this->input->post('status'));
            }

            if($this->input->post('custom_view')){
                $custom_view = $this->input->post('custom_view');
                if($custom_view == 'not_sent'){
                     array_push($where,'AND sent=0');
                 }
            }
 
            $sIndexColumn = "billid";
            $sTable       = 'tblbills';
            $result       = data_tables_init($aColumns, $sIndexColumn, $sTable, $join, $where, array('billid','supplier','symbol'));
            $output       = $result['output'];
            $rResult      = $result['rResult'];

            foreach ($rResult as $aRow) {
                $row = array();

                for ($i = 0; $i < count($aColumns); $i++) {
                    $_data  = $aRow[$aColumns[$i]];
                     if ($aColumns[$i] == 'status') {
                     $_data = format_bills_status($aRow['status']);
                     }
                     else if ($aColumns[$i] == 'bill_date') {
                         $_data  = _d($_data);
                     }
                     else if ($aColumns[$i] == 'supplierid') {
                         $_data  =  '<a href="' . admin_url('suppliers/supplier/' . $aRow['supplierid']) . '">' . $aRow['supplier'] . '</a>';
                     }
                     else if ($aColumns[$i] == 'total') {
                         $_data  =  format_money($_data, $aRow['symbol']);
                     }else if ($aColumns[$i] == 'due_date') {
                         $_data  = _d($_data);
                     }
                     else if ($aColumns[$i] == 'due_date') {
                         $_data  = _d($_data);
                     }
                     else if ($aColumns[$i] == 'billid') {
                         $_data  = '$0.00';
                     }
                    $row[] = $_data;
                }
                
                
//                 $options = "<a href='".admin_url('payments/newpayment/'. $aRow['billid'])."'><i class='fa fa-money'  aria-hidden='true'></i></a>";    
                $options = icon_btn('admin/bills/bill/' . $aRow['billid'], 'pencil-square-o','',array('data-toggle' => 'tooltip', 'title' =>'Edit Bill'));
                $row[] = $options .= icon_btn('admin/bills/delete/' . $aRow['billid'], 'remove', ' btn-delete-customer', array('data-toggle' => 'tooltip', 'title' => 'Delete Bill'));

                $output['aaData'][] = $row;
            }

            echo json_encode($output);
            die();
        }

        $data['estimateid'] = '';
        if (is_numeric($id)) {
            $data['estimateid'] = $id;
        }

        $data['status'] = $_status;
        $data['bodyclass'] = 'small-table';
        $data['title']     = _l('bill');
        $this->load->view('admin/bills/manage', $data);
    }

    /* Add new estimate or update existing */
    public function bill($id = '')
    {
         if(!has_permission('manageBills')){
            access_denied('manageBills');
         }
        $this->load->model('clients_model');
        if ($this->input->post()) {
            // echo "<pre>";
            // print_r($this->input->post());
            // die;
            if ($id == '') {
                $id = $this->bills_model->add($this->input->post());
                // $id = $this->bills_model->add11($this->input->post());
                if ($id) {
  
             
                    set_alert('success', _l('added_successfuly',_l('bill')));
                    if (trim($this->input->post('action')) == 'save') {
                          redirect(admin_url('bills/bill/'. $id));
                        exit;
                    }
                    if (trim($this->input->post('action')) == 'snew') {
                        redirect(admin_url('bills/bill'));
                        exit;
                    }
                 
                    if (trim($this->input->post('action')) == 'slist') {
                         redirect(admin_url('bills/'));
                         
                    }
                    if (trim($this->input->post('action')) == 'cancel') {
                        redirect(admin_url());
                        exit;
                    }
                   // redirect(admin_url('bill/list_bill/' . $id));
                }
            } else {
                $success = $this->bills_model->update($this->input->post(), $id);
                if ($success) {
                   set_alert('success', _l('updated_successfuly',_l('bill')));
                }
               if (trim($this->input->post('action')) == 'save') {
                          redirect(admin_url('bills/bill/'. $id));
                        exit;
                    }
                    if (trim($this->input->post('action')) == 'snew') {
                        redirect(admin_url('bills/bill'));
                        exit;
                    }
                 
                    if (trim($this->input->post('action')) == 'slist') {
                         redirect(admin_url('bills/'));
                         
                    }
                    if (trim($this->input->post('action')) == 'cancel') {
                        redirect(admin_url());
                        exit;
                    }
            }
        }

        

        if ($id == '') {
            $title = _l('create_new_bill');
            if($this->input->get('po_id'))
            {
                // echo $this->input->get('purchase_order_id');
                $data['po_items'] = $this->bills_model->get_po_item($this->input->get('po_id'));
                $data['po'] = $this->bills_model->get_po($this->input->get('po_id'));

             
            }
        } else {
            $bill = $this->bills_model->get($id);

            $data['contacts'] = $this->bills_model->get_where_contacts($bill->supplierid);
            $data['bill_items'] = $this->bills_model->get_bill_items($id);
            $data['supplier_bill_item'] = $this->bills_model->get_supplier_bill_items($id);

            $bill->bill_date    = _d($bill->bill_date);
            $bill->due_date = _d($bill->due_date);


        
            $data['bill']  = $bill;
            $data['edit'] = true;
            $title           = _l('edit','Bill');
        }


        $this->load->model('currencies_model');
        $data['currencies'] = $this->currencies_model->get();
         $this->load->model('vouchers_model');
        $data['ledgers'] = $this->vouchers_model->get_ledgers();

        $this->load->model('taxes_model');
        $data['taxes'] = $this->taxes_model->get();

        $data['prev'] = $this->bills_model->get_prev_groups2();
        $this->load->model('clients_model');
        $data['supplier'] = $this->bills_model->get_supplier();

        $data['title']     = $title;
        $this->load->view('admin/bills/bill', $data);
    }

    public function init_estimate_items_ajax($id){
        echo json_encode($this->bills_model->get_estimate_items($id));
    }
    public function change_quote_status($status,$id){
          echo $this->bills_model->change_quote_status($status,$id);
    }
    public function get_term() {
        echo json_encode($this->bills_model->get_term($this->input->post('id')));
    }
    /* Get all estimate data used when user click on estimate number in a datatable left side*/
    public function get_estimate_data_ajax($id)
    {
        if(!has_permission('manageBills')){
            access_denied('manageBills');
        }

        if (!$id) {
            die('No estimate found');
        }

        $estimate = $this->bills_model->get($id);
         $estimate->date    = _d($estimate->date);
        $estimate->expirydate = _d($estimate->expirydate);

        if($estimate->invoiceid !== NULL){
            $this->load->model('invoices_model');
            $estimate->invoice = $this->invoices_model->get($estimate->invoiceid);
        }
        if($estimate->orderid !== NULL){
            $this->load->model('orders_model');
            $estimate->order = $this->orders_model->get($estimate->orderid);
     
        }

        $this->load->model('emails_model');

        if ($estimate->sent == 0) {
            $data['template'] = $this->emails_model->parse_template('estimate-send-to-client', $estimate->clientid, false,false,false,$id);
        } else {
            $data['template'] = $this->emails_model->parse_template('estimate-already-send', $estimate->clientid, false,false,false,$id);
        }

        $data['activity'] = $this->bills_model->get_estimate_activity($id);
        $data['estimate']  = $estimate;
     
        $this->load->view('admin/bill/estimate_preview_template', $data);
    }

    public function get_bill_total(){
        if(!has_permission('manageBills')){
            access_denied('manageBills');
        }
        if($this->input->post()){
            $data['totals'] = $this->bills_model->get_bill_total($this->input->post());
           
            $this->load->model('currencies_model');
            $base_currency = $this->currencies_model->get_base_currency()->id;
                
//            if((total_rows('tblbill',array('currency'=>$base_currency)) == 0) && total_rows('tblbill') > 0){
//        
//                $this->load->model('currencies_model');
//                $data['currencies'] = $this->currencies_model->get();
//            }
        
            $this->load->view('admin/bills/bills_total_template',$data);
        }
    }

    /* Send estimate to email */
    public function send_to_email($id)
    {
         if(!has_permission('manageBills')){
            access_denied('manageBills');
         }
        $success = $this->bills_model->sent_estimate_to_client($id,'',$this->input->post('attach_pdf'));
        if ($success) {
            set_alert('success', _l('estimate_sent_to_client_success'));

        } else {
            set_alert('danger', _l('estimate_sent_to_client_fail'));
        }
        redirect(admin_url('bill/list_bill/' . $id));
    }

    /* Convert estimate to invoice */
    public function convert_to_invoice($id){

        if(!has_permission('manageBills')){
            access_denied('manageBills');
         }

        if(!$id){
            die('No estimate found');
        }

        $invoiceid = $this->bills_model->convert_to_invoice($id);

        if($invoiceid){
            set_alert('success',_l('estimate_convert_to_invoice_successfuly'));
            redirect(admin_url('invoices/list_invoices/'.$invoiceid));
        } else {
            redirect(admin_url('bill/list_bill/'.$id));
        }
    }
    /* Convert estimate to order */
    public function convert_to_order($id){

        if(!has_permission('manageBills')){
            access_denied('manageBills');
         }

        if(!$id){
            die('No estimate found');
        }

         $orderid= $this->bills_model->convert_to_order($id);

        if($orderid){
            set_alert('success',_l('estimate_convert_to_order_successfuly'));
            redirect(admin_url('orders/list_orders/'.$orderid));
        } else {
            redirect(admin_url('bill/list_bill/'.$id));
        }
    }

    /* Delete estimate */
    public function delete($id)
    {
         if(!has_permission('manageBills')){
            access_denied('manageBills');
         }

        if (!$id) {
            redirect(admin_url('bills'));
        }

        $success = $this->bills_model->delete($id);

        if ($success) {
           set_alert('success', _l('deleted',_l('bill')));
        } else {
            set_alert('warning', _l('problem_deleting',_l('bill')));
        }

        redirect(admin_url('bills'));
    }

    /* Generates estimate PDF and senting to email of $send_to_email = true is passed */
    public function pdf($id, $send_to_email = false)
    {
        if(!has_permission('manageBills')){
            access_denied('manageBills');
        }

        if (!$id) {
            redirect(admin_url('bill/list_bill'));
        }

        $quote        = $this->bills_model->get($id);
     
        $quote_number = format_estimate_number($quote->number);
        $pdf              =   estimate_pdf($quote);
        $pdf->Output($quote_number . '.pdf', 'D');
    }
    public function get_contact(){
        echo json_encode($this->bills_model->get_contact($this->input->post('id')));
    }
       public function get_contacts(){
       $contacts =  $this->bills_model->get_contacts($this->input->post('id'));
       $html = "<option value=''></option>";
       foreach ($contacts as $value) {
          $html .= "<option value='$value->id'>$value->firstname $value->lastname</opyion>"; 
       }
       echo json_encode(array('contacts'=>$html));
    }
    public function make_payment($id = ''){
        if($this->input->post() && !$this->input->is_ajax_request()){
			if(!has_permission('manageBills')){
				access_denied('manageBills');
			}

			if($id == ''){
		
				$id = $this->bills_model->add1($this->input->post());
			
				if($id){
					set_alert('success', _l('added_successfuly',_l('billpayment')));
                                        if (trim($this->input->post('action')) == 'save') {
                                             redirect(admin_url('bills/make_payment'));
                                           exit;
                                       }
                                       if (trim($this->input->post('action')) == 'snew') {
                                           redirect(admin_url('bills/make_payment'));
                                           exit;
                                       }
                                      if (trim($this->input->post('action')) == 'slist') {
                                            redirect(admin_url('bills/payments'));

                                       }
                                       if (trim($this->input->post('action')) == 'cancel') {
                                           redirect(admin_url('bills/payments'));
                                           exit;
                                       }
                                        
					
				}
			} else {
				
			
				$success = $this->banks_model->update($this->input->post(),$id);
				if($success){
					set_alert('success', _l('updated_successfuly',_l('billpayment')));
				}
                                      if (trim($this->input->post('action')) == 'save') {
                                             redirect(admin_url('bills/make_payment'));
                                           exit;
                                       }
                                       if (trim($this->input->post('action')) == 'snew') {
                                           redirect(admin_url('bills/make_payment'));
                                           exit;
                                       }
                                      if (trim($this->input->post('action')) == 'slist') {
                                            redirect(admin_url('bills/payments'));

                                       }
                                       if (trim($this->input->post('action')) == 'cancel') {
                                           redirect(admin_url('bills/payments'));
                                           exit;
                                       }
                                        
			}
		}

		if($id == ''){
			$title = 'Pay Bill';
            $data['getsupplier'] = $this->bills_model->getsupplier($this->input->get('billid'));
          
            $data['billid'] = $this->input->get('billid');

		} else {
	
			// $bank = $this->banks_model->get($id);
             
			// $data['bank'] = $bank;
              
            // $data['prev'] = $this->banks_model->get_prev($id);
            // $data['next'] = $this->banks_model->get_next($id);
            // $title = $bank->bank;
            
		}
        $this->load->model('vouchers_model');
        $data['ledgers'] = $this->vouchers_model->get_ledgers();
        $data['supplier'] = $this->bills_model->get_supplier();
        $this->load->model('banksaccounts_model');
        $data['banks'] = $this->banksaccounts_model->get_banks();

	
        $data['title'] = $title;
      	
		$this->load->view('admin/bills/paybill',$data);
        
    }
        public function get_branches(){
        if ($this->input->is_ajax_request()) {
           $this->load->model('BankingAccountTransfer_model');
          $res = $this->BankingAccountTransfer_model->get_branches();
          $options ='<option value=""></option>';
          if(isset($res)){
              foreach ($res as $value) {
               $options .='<option value="'.$value->bankbranchid.'">'.$value->branchname.'</option>';   
              }
          }
          echo json_encode(array('options'=>$options));
        }
    }
      public function get_accounts(){
        if ($this->input->is_ajax_request()) {
               $this->load->model('BankingAccountTransfer_model');
          $res = $this->BankingAccountTransfer_model->get_accounts();
          $options ='<option value=""></option>';
          if(isset($res)){
              foreach ($res as $value) {
               $options .='<option value="'.$value->id.'">'.$value->account_number.'</option>';   
              }
          }
          echo json_encode(array('options'=>$options));
        }
    }
    public function get_accounts_details(){
       $this->load->model('BankingAccountTransfer_model');
       $result = $this->BankingAccountTransfer_model->get_accounts_details();

         $array = array(
           'balance'=>number_format($result->balance,2),
           'overdraft'=>number_format($result->overdraft,2),
           'available'=>number_format($result->available,2),
           
       );
       echo json_encode($array);
    }

    public function list_bills($supplierid = false,$amout)
    {
        $has_permission = has_permission('managePayments');

         if(!$has_permission && !$this->input->is_ajax_request()){
            access_denied('manageBills');
         }

        $_custom_view = '';
        $_status = '';

        if($this->input->get('custom_view')){
            $_custom_view = $this->input->get('custom_view');
        } else if($this->input->get('status')){
             $_status = $this->input->get('status');
        }

        if ($this->input->is_ajax_request()) {
            // From client profile
            if(is_numeric($supplierid)){
                if(!$has_permission){
                    echo json_encode(json_decode('{"draw":1,"iTotalRecords":"0","iTotalDisplayRecords":"0","aaData":[]}'));
                    die;
                }
            }

            $aColumns = array(
                'tblbills.billid',
                'bill_date',
                'currency',
                'bill_number',
                'total',
                'due_date',
                'tblbills.note',
                'status',
                'contact'
                
            );

            $join = array(
                'LEFT JOIN tblsuppliers ON tblsuppliers.userid = tblbills.supplierid',
                'LEFT JOIN tblcurrencies ON tblcurrencies.id = tblbills.currency'
            );

            $where   = array();

           // if (is_numeric($supplierid)) {
            if(!$supplierid){
              $supplierid=0;  
            }
                $where= array(
                    'AND supplierid=' . $supplierid
                );

           // }
            

            if ($this->input->post('status')) {
                array_push($where, 'AND status=' . $this->input->post('status'));
               
            }
              array_push($where,'AND  tblbills.status !=2');


            $sIndexColumn = "billid";
            $sTable       = 'tblbills';
            $result       = data_tables_init($aColumns, $sIndexColumn, $sTable, $join, $where, array(
                'supplier',
                'tblbills.billid',
                'userid',
                'symbol',
                'total',
                'status'
            ),$orderby = 'ORDER BY `tblbills`.`status` DESC');
            $output       = $result['output'];
            $rResult      = $result['rResult'];
  
            foreach ($rResult as $aRow) {
                $row = array();

                for ($i = 0; $i < count($aColumns); $i++) {
                    $_data                    = $aRow[$aColumns[$i]];

                    if ($aColumns[$i] == 'bill_number') {
                      $__data = '<a href="' . admin_url('bills/bill/' . $aRow['billid']) . '">' . $_data . '</a><br />';
                    }else if ($aColumns[$i] == 'bill_date') {
                        $__data = _d($_data);
                    } else if ($aColumns[$i] == 'tblbills.billid') {
                        $__data = '<input type="checkbox"  class="billid" name="billids[]" value="'. $aRow['billid'].'" />' ;
                    }  else if ($aColumns[$i] == 'currency') {
                        $__data = 'Bill' ;
                        
                    }else if ($aColumns[$i] == 'due_date') {
                        $__data = _d($_data);
                    } else if ($aColumns[$i] == 'total') {
                        $__data = "<input type='hidden' value='".$_data."' id='original_amout'>". format_money($_data, $aRow['symbol']);
                    } else if ($aColumns[$i] == 'contact') {
                          $paidamount = $this->bills_model->getbalance($aRow['billid']);
                        $apply=$aRow["total"]- $paidamount;
                        $__data = '<input type="text" style="width:100px" name="applyamount[]" value="" data-text="'.format_money($apply).'"  class="applyamount"/>';
                    }
                    else if ($aColumns[$i] == 'note') {
                       $paidamount = $this->bills_model->getbalance($aRow['billid']);
                        $__data = format_money($aRow['total']- $paidamount, $aRow['symbol']);
            
                    }else if ($aColumns[$i] == 'status'){
                        $__data = format_bills_status($aRow['status']);
                        // Status
                    }
                    else
                    {
                        $balance = $aRow['total'] - $amout;
                        // print_r($balance);
                        // $balance = format_money($balance, $aRow['symbol']);
                        $__data = '<input type="text" style="width:100px" id="bill_balance" value="'.$balance.'"  class="bill_balance" readonly/>';
                    }
                    $row[] = $__data;
                }
                // die;

                $output['aaData'][] = $row;
            }

            echo json_encode($output);
            die();
        }


    }
    public function payments(){
        
        $has_permission = has_permission('manageBills');

        if(!$has_permission && !$this->input->is_ajax_request()){
            access_denied('manageBills');
        }

        $_custom_view = '';

        if($this->input->get('custom_view')){
            $_custom_view = $this->input->get('custom_view');
        }

        if ($this->input->is_ajax_request()) {
            // From client profile
            if(is_numeric($clientid)){
                if(!$has_permission){
                    echo json_encode(json_decode('{"draw":1,"iTotalRecords":"0","iTotalDisplayRecords":"0","aaData":[]}'));
                    die;
                }
            }

            $aColumns = array(
                'number',
                'bill_date',
                'billamount',
                'type',
                'note',
              
            );

            $join = array();

            $where = array();
           
            $sIndexColumn = "id";
            $sTable       = 'tblpaidbills';
            $result       = data_tables_init($aColumns, $sIndexColumn, $sTable, $join, $where, array(
                'id',
            ));
            $output       = $result['output'];
            $rResult      = $result['rResult'];

    
            foreach ($rResult as $aRow) {
                $row = array();

                for ($i = 0; $i < count($aColumns); $i++) {
                    $_data = $aRow[$aColumns[$i]];
                    if ($aColumns[$i] == 'billamount') {
                        $_data = format_money($aRow['billamount'],'$');
                    }
                    if ($aColumns[$i] == 'number') {
                        $_data = format_paybill_number($aRow['number']);
                    }
                    if ($aColumns[$i] == 'bill_date') {
                        $_data = _d($_data);
                    }
                    if ($aColumns[$i] == 'type') {
                        if($aRow['billamount'] =='checkpayment'){
                          $_data = 'Direct Check Payment';   
                        }else{
                            $_data = 'Supplier';     
                        }
                       
                    }

                    $row[] = $_data;
                }

//                $options            = icon_btn('admin/payments/payment/' . $aRow['id'], 'pencil-square-o');
//                $row[]              = $options = icon_btn('admin/bill/delete/' . $aRow['id'], 'remove', '');
                $output['aaData'][] = $row;
            }
            echo json_encode($output);
            die();
        }

        $data['custom_view'] = $_custom_view;
        $data['title'] = _l('billpayments');
        $this->load->view('admin/bills/paymentslist', $data);
    }

    public function get_paymentterms()
    {
        $id = $this->input->post('id');
        $payment_terms = $this->bills_model->getsupplier_paymentterms($id);
        echo $payment_terms->payment_term;

    }
}
